<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('lang', 10)->default('en')->index()->nullable();
            $table->string('title', 100)->index()->nullable();
            $table->mediumText('value')->nullable();
            $table->timestamps();
        });
        $now = now();
        \Illuminate\Support\Facades\DB::unprepared("INSERT INTO `settings` (`id`, `lang`, `title`, `value`, `created_at`, `updated_at`) VALUES
        (1, 'en', 'current_version', '167', '$now', '$now'),
(2, 'en', 'default_language', 'en', '$now', '$now'),
(3, 'en', 'system_name', 'Yoori e-Commerce CMS', '$now', '$now'),
(4, 'en', 'default_time_zone', 'Asia/Dhaka', '$now', '$now'),
(5, 'en', 'default_currency', '1', '$now', '$now'),
(6, 'en', 'favicon', NULL, '$now', '$now'),
(7, 'en', 'https', '0', '$now', '$now'),
(8, 'en', 'maintenance_mode', '0', '$now', '$now'),
(9, 'en', 'seller_system', '1', '$now', '$now'),
(10, 'en', 'classified_product', '1', '$now', '$now'),
(11, 'en', 'seller_product_auto_approve', '0', '$now', '$now'),
(12, 'en', 'wallet_system', '1', '$now', '$now'),
(13, 'en', 'coupon_system', '1', '$now', '$now'),
(14, 'en', 'pickup_point', '1', '$now', '$now'),
(15, 'en', 'conversation', '1', '$now', '$now'),
(16, 'en', 'color', '1', '$now', '$now'),
(17, 'en', 'mail_driver', 'smtp', '$now', '$now'),
(18, 'en', 'smtp_mail_host', 'smtp.gmail.com', '$now', '$now'),
(19, 'en', 'smtp_mail_port', '587', '$now', '$now'),
(20, 'en', 'smtp_mail_address', NULL, '$now', '$now'),
(21, 'en', 'smtp_name', 'YOORI', '$now', '$now'),
(22, 'en', 'smtp_mail_username', NULL, '$now', '$now'),
(23, 'en', 'smtp_mail_password', NULL, '$now', '$now'),
(24, 'en', 'smtp_mail_encryption_type', 'tls', '$now', '$now'),
(25, 'en', 'sendgrid_mail_host', 'smtp.sendgrid.net', '$now', '$now'),
(26, 'en', 'sendgrid_mail_port', '587', '$now', '$now'),
(27, 'en', 'sendgrid_mail_address', NULL, '$now', '$now'),
(28, 'en', 'sendgrid_name', 'yoori', '$now', '$now'),
(29, 'en', 'sendgrid_mail_username', 'apikey', '$now', '$now'),
(30, 'en', 'sendgrid_mail_password', NULL, '$now', '$now'),
(31, 'en', 'sendgrid_mail_encryption_type', 'tls', '$now', '$now'),
(32, 'en', 'sendmail_path', NULL, '$now', '$now'),
(33, 'en', 'mailgun_mail_host', 'smtp.mailgun.org', '$now', '$now'),
(34, 'en', 'mailgun_mail_port', '587', '$now', '$now'),
(35, 'en', 'mailgun_mail_address', NULL, '$now', '$now'),
(36, 'en', 'mailgun_name', 'yoori', '$now', '$now'),
(37, 'en', 'mailgun_mail_username', NULL, '$now', '$now'),
(38, 'en', 'mailgun_mail_password', NULL, '$now', '$now'),
(39, 'en', 'mailgun_mail_encryption_type', 'tls', '$now', '$now'),
(40, 'en', 'mailgun_domain', NULL, '$now', '$now'),
(41, 'en', 'mailgun_secret', NULL, '$now', '$now'),
(42, 'en', 'mail_signature', NULL, '$now', '$now'),
(43, 'en', 'currency_symbol_format', 'symbol_amount', '$now', '$now'),
(44, 'en', 'decimal_separator', '.', '$now', '$now'),
(45, 'en', 'no_of_decimals', '2', '$now', '$now'),
(46, 'en', 'default_storage', 'local', '$now', '$now'),
(47, 'en', 'aws_access_key_id', NULL, '$now', '$now'),
(48, 'en', 'aws_secret_access_key', NULL, '$now', '$now'),
(49, 'en', 'aws_default_region', NULL, '$now', '$now'),
(50, 'en', 'aws_bucket', NULL, '$now', '$now'),
(51, 'en', 'image_optimization', '1', '$now', '$now'),
(52, 'en', 'image_optimization_percentage', '80', '$now', '$now'),
(53, 'en', 'is_cache_enabled', 'disable', '$now', '$now'),
(54, 'en', 'default_cache', 'file', '$now', '$now'),
(55, 'en', 'redis_host', NULL, '$now', '$now'),
(56, 'en', 'redis_password', NULL, '$now', '$now'),
(57, 'en', 'redis_port', NULL, '$now', '$now'),
(58, 'en', 'memcached_host', NULL, '$now', '$now'),
(59, 'en', 'memcached_password', NULL, '$now', '$now'),
(60, 'en', 'memcached_port', NULL, '$now', '$now'),
(61, 'en', 'pagination', '15', '$now', '$now'),
(62, 'en', 'api_paginate', '20', '$now', '$now'),
(63, 'en', 'index_form_paginate', '10', '$now', '$now'),
(64, 'en', 'media_paginate', '32', '$now', '$now'),
(65, 'en', 'order_prefix', 'YR', '$now', '$now'),
(66, 'en', 'primary_color', '#ea2424', '$now', '$now'),
(67, 'en', 'secondary_color', '#333333', '$now', '$now'),
(68, 'en', 'full_width_menu_background', '1', '$now', '$now'),
(69, 'en', 'menu_background_color', '#fcb800', '$now', '$now'),
(70, 'en', 'menu_text_color', '#444444', '$now', '$now'),
(71, 'en', 'menu_border_bottom_color', '#EEEEEE', '$now', '$now'),
(72, 'en', 'fonts', 'Poppins', '$now', '$now'),
(73, 'en', 'meta_title', NULL, '$now', '$now'),
(74, 'en', 'meta_description', NULL, '$now', '$now'),
(75, 'en', 'keyword', NULL, '$now', '$now'),
(76, 'en', 'article', NULL, '$now', '$now'),
(77, 'en', 'og_image', NULL, '$now', '$now'),
(78, 'en', 'popup_title', NULL, '$now', '$now'),
(79, 'en', 'popup_description', NULL, '$now', '$now'),
(80, 'en', 'popup_show_in', 'home_page', '$now', '$now'),
(81, 'en', 'popup_image', NULL, '$now', '$now'),
(82, 'en', 'site_popup_status', '0', '$now', '$now'),
(83, 'en', 'custom_css', NULL, '$now', '$now'),
(84, 'en', 'custom_header_script', NULL, '$now', '$now'),
(85, 'en', 'custom_footer_script', NULL, '$now', '$now'),
(86, 'en', 'cookies_agreement', '<p><b>Notice: </b>Yoori uses cookies to provide necessary website functionality, improve your experience and analyze our traffic. By using our website, you agree to our Privacy Policy and our Cookies Policy.<br></p>', '$now', '$now'),
(87, 'en', 'cookies_status', '0', '$now', '$now'),
(88, 'en', 'header_theme', 'header_theme1', '$now','$now'),
(91, 'en', 'header_contact_number', '1', '$now', '$now'),
(92, 'en', 'header_contact_phone', '8801234567890', '$now', '$now'),
(93, 'en', 'header_contact_email', 'support@website.com', '$now', '$now'),
(94, 'en', 'language_switcher', '1', '$now', '$now'),
(95, 'en', 'currency_switcher', '1', '$now', '$now'),
(96, 'en', 'topbar_play_store_link', '0', '$now', '$now'),
(97, 'en', 'topbar_app_store_link', '0', '$now', '$now'),
(98, 'en', 'banner_link', NULL, '$now', '$now'),
(99, 'en', 'banner_image', '[]', '$now', '$now'),
(100, 'en', 'header_menu', 'a:7:{i:0;a:2:{s:5:\"label\";s:4:\"Home\";s:3:\"url\";s:1:\"/\";}i:1;a:2:{s:5:\"label\";s:8:\"Products\";s:3:\"url\";s:9:\"/products\";}i:2;a:2:{s:5:\"label\";s:10:\"Categories\";s:3:\"url\";s:11:\"/categories\";}i:3;a:2:{s:5:\"label\";s:6:\"Brands\";s:3:\"url\";s:7:\"/brands\";}i:4;a:2:{s:5:\"label\";s:9:\"Campaigns\";s:3:\"url\";s:10:\"/campaigns\";}i:5;a:2:{s:5:\"label\";s:7:\"Sellers\";s:3:\"url\";s:8:\"/sellers\";}i:6;a:5:{s:5:\"label\";s:5:\"Pages\";s:3:\"url\";s:18:\"javascript:void(0)\";i:0;a:2:{s:5:\"label\";s:5:\"Blogs\";s:3:\"url\";s:6:\"/blogs\";}i:1;a:2:{s:5:\"label\";s:8:\"About Us\";s:3:\"url\";s:11:\"/page/about\";}i:2;a:2:{s:5:\"label\";s:10:\"Contact Us\";s:3:\"url\";s:8:\"/contact\";}}}', '$now', '$now'),
(101, 'en', 'footer_theme', 'footer_theme1', '$now', '$now'),
(102, 'en', 'about_description', '<p><span style=\"font-family: Poppins, Helvetica, sans-serif;\"><font color=\"#767676\"><b>Yoori&nbsp;</b></font></span><span style=\"color: rgb(102, 102, 102); font-family: Roboto, Helvetica, sans-serif;\">being the trusted online shop in over the world aims to provide a trouble-free shopping experience for the people of the world but is also providing ample opportunity for international online shopping from yoori.&nbsp;</span><span style=\"font-size: 0.875rem; font-family: Roboto, Helvetica, sans-serif;\"><font color=\"#767676\"><span style=\"font-weight: bolder;\">Yoori&nbsp;</span></font></span><span style=\"font-size: 0.875rem; color: rgb(102, 102, 102); font-family: Roboto, Helvetica, sans-serif;\">being the trusted online shop in over the world aims to provide a trouble-free shopping experience for the people of the world but is also providing ample opportunity for international online shopping from yoori.&nbsp;</span>', '$now', '$now'),
(106, 'en', 'show_social_links', '1', '$now', '$now'),
(107, 'en', 'footer_contact_phone', '01234567890', '$now', '$now'),
(108, 'en', 'footer_contact_email', 'test@spagreen.net', '$now', '$now'),
(109, 'en', 'footer_contact_address', NULL, '$now', '$now'),
(110, 'en', 'copyright', '©Yoori by SpaGreen Creative 2022, All Rights Reserved.', '$now', '$now'),
(111, 'en', 'footer_menu', 'a:6:{i:0;a:2:{s:5:\"label\";s:4:\"Home\";s:3:\"url\";s:1:\"/\";}i:1;a:2:{s:5:\"label\";s:14:\"All Categories\";s:3:\"url\";s:10:\"categories\";}i:2;a:2:{s:5:\"label\";s:10:\"All Brands\";s:3:\"url\";s:6:\"brands\";}i:3;a:2:{s:5:\"label\";s:12:\"All Products\";s:3:\"url\";s:8:\"products\";}i:4;a:2:{s:5:\"label\";s:5:\"Blogs\";s:3:\"url\";s:5:\"blogs\";}i:5;a:2:{s:5:\"label\";s:9:\"Campaigns\";s:3:\"url\";s:9:\"campaigns\";}}', '$now', '$now'),
(112, 'en', 'useful_links', 'a:7:{i:0;a:2:{s:5:\"label\";s:11:\"Latest News\";s:3:\"url\";s:6:\"/blogs\";}i:1;a:2:{s:5:\"label\";s:19:\"Browse All Products\";s:3:\"url\";s:9:\"/products\";}i:2;a:2:{s:5:\"label\";s:19:\"Browse All Category\";s:3:\"url\";s:11:\"/categories\";}i:3;a:2:{s:5:\"label\";s:17:\"Browse All Brands\";s:3:\"url\";s:7:\"/brands\";}i:4;a:2:{s:5:\"label\";s:18:\"Terms & Conditions\";s:3:\"url\";s:22:\"/page/terms-conditions\";}i:5;a:2:{s:5:\"label\";s:14:\"Privacy Policy\";s:3:\"url\";s:20:\"/page/privacy-policy\";}i:6;a:2:{s:5:\"label\";s:13:\"Refund Policy\";s:3:\"url\";s:19:\"/page/refund-policy\";}}', '$now', '$now'),
(113, 'en', 'facebook_link', 'https://www.facebook.com/', '$now', '$now'),
(114, 'en', 'twitter_link', 'https://www.twitter.com/', '$now', '$now'),
(115, 'en', 'instagram_link', 'https://www.instagram.com/', '$now', '$now'),
(116, 'en', 'youtube_link', 'https://www.youtube.com/', '$now', '$now'),
(117, 'en', 'linkedin_link', 'https://www.linked.com/', '$now', '$now'),
(118, 'en', 'social_link_status', '0', '$now', '$now'),
(119, 'en', 'payment_method_banner', '', '$now', '$now'),
(120, 'en', 'active_sms_provider', NULL, '$now', '$now'),
(121, 'en', 'sms_method', NULL, '$now', '$now'),
(122, 'en', 'twilio_sms_sid', NULL, '$now', '$now'),
(123, 'en', 'twilio_sms_auth_token', NULL, '$now', '$now'),
(124, 'en', 'valid_twilio_sms_number', NULL, '$now', '$now'),
(125, 'en', 'is_twilio_sms_activated', '0', '$now', '$now'),
(126, 'en', 'fast_2_auth_key', NULL, '$now', '$now'),
(127, 'en', 'fast_2_entity_id', NULL, '$now', '$now'),
(128, 'en', 'fast_2_route', NULL, '$now', '$now'),
(129, 'en', 'fast_2_language', NULL, '$now', '$now'),
(130, 'en', 'fast_2_sender_id', NULL, '$now', '$now'),
(131, 'en', 'is_fast_2_activated', '0', '$now', '$now'),
(132, 'en', 'spagreen_url', NULL, '$now', '$now'),
(133, 'en', 'spagreen_sms_api_key', NULL, '$now', '$now'),
(134, 'en', 'spagreen_secret_key', NULL, '$now', '$now'),
(135, 'en', 'is_spagreen_sms_activated', '0', '$now', '$now'),
(136, 'en', 'mimo_username', NULL, '$now', '$now'),
(137, 'en', 'mimo_sms_password', NULL, '$now', '$now'),
(138, 'en', 'mimo_sms_sender_id', NULL, '$now', '$now'),
(139, 'en', 'is_mimo_sms_activated', '0', '$now', '$now'),
(140, 'en', 'nexmo_sms_key', NULL, '$now', '$now'),
(141, 'en', 'nexmo_sms_secret_key', NULL, '$now', '$now'),
(142, 'en', 'type', NULL, '$now', '$now'),
(143, 'en', 'is_nexmo_sms_activated', '0', '$now', '$now'),
(144, 'en', 'ssl_sms_api_token', NULL, '$now', '$now'),
(145, 'en', 'ssl_sms_sid', NULL, '$now', '$now'),
(146, 'en', 'ssm_sms_url', NULL, '$now', '$now'),
(147, 'en', 'is_ssl_wireless_sms_activated', '0', '$now', '$now'),
(148, 'en', 'payment_method', NULL, '$now', '$now'),
(149, 'en', 'paypal_client_id', NULL, '$now', '$now'),
(150, 'en', 'paypal_client_secret', NULL, '$now', '$now'),
(151, 'en', 'is_paypal_activated', '0', '$now', '$now'),
(152, 'en', 'is_paypal_sandbox_mode_activated', '0', '$now', '$now'),
(153, 'en', 'stripe_key', NULL, '$now', '$now'),
(154, 'en', 'stripe_secret', NULL, '$now', '$now'),
(155, 'en', 'is_stripe_activated', '0', '$now', '$now'),
(156, 'en', 'is_stripe_sandbox_mode_activated', '0', '$now', '$now'),
(157, 'en', 'sslcommerz_id', NULL, '$now', '$now'),
(158, 'en', 'sslcommerz_password', NULL, '$now', '$now'),
(159, 'en', 'is_sslcommerz_activated', '0', '$now', '$now'),
(160, 'en', 'is_sslcommerz_sandbox_mode_activated', '0', '$now', '$now'),
(161, 'en', 'merchant_id', NULL, '$now', '$now'),
(162, 'en', 'merchant_key', NULL, '$now', '$now'),
(163, 'en', 'merchant_website', NULL, '$now', '$now'),
(164, 'en', 'channel', NULL, '$now', '$now'),
(165, 'en', 'industry_type', NULL, '$now', '$now'),
(166, 'en', 'is_paytm_activated', '0', '$now', '$now'),
(167, 'en', 'is_paytm_sandbox_mode_activated', '0', '$now', '$now'),
(168, 'en', 'jazz_cash_merchant_id', NULL, '$now', '$now'),
(169, 'en', 'jazz_cash_password', NULL, '$now', '$now'),
(170, 'en', 'jazz_cash_integrity_salt', NULL, '$now', '$now'),
(171, 'en', 'is_jazz_cash_activated', '0', '$now', '$now'),
(172, 'en', 'razorpay_key', NULL, '$now', '$now'),
(173, 'en', 'razorpay_secret', NULL, '$now', '$now'),
(174, 'en', 'is_razorpay_activated', '0', '$now', '$now'),
(175, 'en', 'api_server_url', NULL, '$now', '$now'),
(176, 'en', 'api_key_app', NULL, '$now', '$now'),
(177, 'en', 'latest_apk_version', NULL, '$now', '$now'),
(178, 'en', 'latest_apk_code', NULL, '$now', '$now'),
(179, 'en', 'apk_file_url', NULL, '$now', '$now'),
(180, 'en', 'whats_new_latest_apk', NULL, '$now', '$now'),
(181, 'en', 'android_skippable', '0', '$now', '$now'),
(182, 'en', 'latest_ipa_version', NULL, '$now', '$now'),
(183, 'en', 'latest_ipa_code', NULL, '$now', '$now'),
(184, 'en', 'ipa_file_url', NULL, '$now', '$now'),
(185, 'en', 'whats_new_latest_ipa', NULL, '$now', '$now'),
(186, 'en', 'ios_skippable', NULL, '$now', '$now'),
(187, 'en', 'privacy_policy_url', NULL, '$now', '$now'),
(188, 'en', 'terms_condition_url', NULL, '$now', '$now'),
(189, 'en', 'support_url', NULL, '$now', '$now'),
(190, 'en', 'intro_skippable', '0', '$now', '$now'),
(191, 'en', 'mandatory_login', '0', '$now', '$now'),
(192, 'en', 'admob_app_id', NULL, '$now', '$now'),
(193, 'en', 'admob_banner_ads_id', NULL, '$now', '$now'),
(194, 'en', 'admob_interstitial_ads_id', NULL, '$now', '$now'),
(195, 'en', 'admob_native_ads_id', NULL, '$now', '$now'),
(196, 'en', 'ads_enable', '0', '$now', '$now'),
(197, 'en', 'seller_commission', NULL, '$now', '$now'),
(198, 'en', 'seller_commission_status', '1', '$now', '$now'),
(199, 'en', 'delivery_hero_payment_type', 'delivery_hero_salary', '$now', '$now'),
(200, 'en', 'delivery_hero_send_mail', '0', '$now', '$now'),
(201, 'en', 'delivery_hero_OTP', '0', '$now', '$now'),
(202, 'en', 'refund_request_time', '10', '$now', '$now'),
(203, 'en', 'refund_sticker', NULL, '$now', '$now'),
(204, 'en', 'reward_convert_rate', '10', '$now', '$now'),
(205, 'en', 'shipping_fee_type', 'product_base', '$now', '$now'),
(206, 'en', 'shipping_fee_flat_rate', '', '$now', '$now'),
(207, 'en', 'shipping_fee_admin_product', NULL, '$now', '$now'),
(208, 'en', 'home_page_contents', 'a:11:{i:0;a:1:{s:6:\"banner\";a:2:{s:9:\"thumbnail\";a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}s:3:\"url\";a:2:{i:0;s:1:\"/\";i:1;s:1:\"/\";}}}i:1;a:1:{s:16:\"popular_category\";a:6:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"6\";i:4;s:1:\"9\";i:5;s:2:\"10\";}}i:2;a:1:{s:11:\"todays_deal\";s:1:\"3\";}i:3;a:1:{s:10:\"flash_deal\";s:1:\"4\";}i:4;a:1:{s:12:\"top_category\";a:5:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:2:\"11\";}}i:5;a:1:{s:16:\"category_section\";a:3:{s:8:\"category\";s:1:\"1\";s:6:\"banner\";s:0:\"\";s:10:\"banner_url\";s:1:\"/\";}}i:6;a:1:{s:21:\"best_selling_products\";a:1:{i:0;s:1:\"7\";}}i:7;a:1:{s:17:\"offer_ending_soon\";a:2:{s:6:\"banner\";s:0:\"\";s:10:\"banner_url\";s:1:\"/\";}}i:8;a:1:{s:14:\"latest_product\";s:1:\"9\";}i:9;a:1:{s:11:\"latest_news\";a:1:{i:0;s:2:\"10\";}}i:10;a:1:{s:14:\"popular_brands\";a:1:{i:0;s:2:\"11\";}}}', '$now', '$now'),
(209, 'en', 'show_service_info_section', '0', '$now', '$now'),
(210, 'en', 'show_subscription_section', '0', '$now', '$now'),
(211, 'en', 'is_facebook_login_activated', '0', '$now', '$now'),
(212, 'en', 'facebook_client_id', NULL, '$now', '$now'),
(213, 'en', 'facebook_client_secret', NULL, '$now', '$now'),
(214, 'en', 'is_google_login_activated', '0', '$now', '$now'),
(215, 'en', 'google_client_id', NULL, '$now', '$now'),
(216, 'en', 'google_client_secret', NULL, '$now', '$now'),
(217, 'en', 'is_twitter_login_activated', '0', '$now', '$now'),
(218, 'en', 'twitter_client_id', NULL, '$now', '$now'),
(219, 'en', 'twitter_client_secret', NULL, '$now', '$now'),
(220, 'en', 'is_pusher_notification_active', '0', '$now', '$now'),
(221, 'en', 'pusher_app_id', NULL, '$now', '$now'),
(222, 'en', 'pusher_app_key', NULL, '$now', '$now'),
(223, 'en', 'pusher_app_secret', NULL, '$now', '$now'),
(224, 'en', 'pusher_app_cluster', NULL, '$now', '$now'),
(225, 'en', 'id', NULL, '$now', '$now'),
(226, 'en', 'home_page_article', '', '$now', '$now'),
(227, 'en', 'show_blog_section', '0', '$now', '$now'),
(228, 'en', 'show_recent_viewed_products', '0', '$now', '$now'),
(229, 'en', 'show_categories_section', '0', '$now', '$now'),
(230, 'en', 'seller_agreement', '', '$now', '$now'),
(231, 'en', 'customer_agreement', '', '$now', '$now'),
(232, 'en', 'privacy_agreement', '', '$now', '$now'),
(233, 'en', 'admin_panel_copyright_text', '©Yoori by SpaGreen Creative 2022, All Rights Reserved.', NULL, NULL),
(234, 'en', 'admin_panel_title', 'Yoori e-Commerce CMS', '$now', '$now'),
(235, 'en', 'system_short_name', 'Yoori', '$now', '$now'),
(239, 'en', 'pay_later_system', '1', '$now', '$now'),
(240, 'en', 'invoice_based_shipping_fee', 'a:1:{i:0;a:3:{s:10:\"min_amount\";s:0:\"\";s:10:\"max_amount\";s:0:\"\";s:3:\"fee\";s:0:\"\";}}', '$now', '$now'),
(241, 'en', 'shipping_fee_default_rate', '', '$now', '$now'),
(242, 'en', 'default_country', '19', NULL, NULL),
(243, 'en', 'refund_protection_title', 'Yoori eCommerce Refund Protection', NULL, NULL),
(244, 'en', 'refund_protection_sub_title', '30 Days cash back Guarantee', NULL, NULL),
(245, 'en', 'refund_policy_agreement', 'refund-policy', NULL, NULL),
(246, 'en', 'purchase_code', '', '$now', '$now'),
(247, 'en', 'mobile_home_page_contents', 'a:8:{i:0;a:1:{s:14:\"latest_product\";s:2:\"10\";}i:1;a:1:{s:12:\"top_category\";a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}}i:2;a:1:{s:21:\"best_selling_products\";a:1:{i:0;s:1:\"2\";}}i:3;a:1:{s:11:\"latest_news\";a:1:{i:0;s:1:\"4\";}}i:4;a:1:{s:11:\"top_sellers\";a:1:{i:0;s:1:\"5\";}}i:5;a:1:{s:12:\"best_sellers\";a:1:{i:0;s:1:\"6\";}}i:6;a:1:{s:10:\"flash_deal\";s:1:\"7\";}i:7;a:1:{s:11:\"todays_deal\";s:1:\"8\";}}', '$now', '$now'),
(248, 'en', 'version_code', '1.6.7', '$now', '$now'),
(249, 'en', 'menu_active_color', '#000000', '$now', '$now'),
(250, 'en', 'button_background_color', '#333333', '$now', '$now'),
(251, 'en', 'button_text_color', '#ffffff', '$now', '$now'),
(252, 'en', 'button_text_color', '#ea2424', '$now', '$now'),
(253, 'en', 'button_border_color', '#333333', '$now', '$now')
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
